// New Quest Notifier 1.1
// 14 August 2017
// by ZylonBane
// Displays a generic notification when new quest notes are added.
//
// Localization
// By default this script displays "Note added to PDA." when a new note is added.
// To change the message displayed, add NoteNew to strings/misc.str. Example:
//   NoteNew:"Updated my journal."
//
// Since Dark doesn't send scripts any global notification for quest state
// changes, every possible quest note must be subscribed to individually.
// For maximum compatibility with the main campaign, main campaign mods, and
// FMs, this script attempts to discover all possible quest notes from 1 to
// 99 for decks 1 to 9 (note_1_1 to note_9_99).
//
// Dark internal quest note states:
//   0 = inactive (not visible)
//   1 = active
//   2 = complete
//   3 = "secret" complete (completed before assigned; not visible)

class zbQuestNew extends SqRootScript {
	static notifyTimer = "nTimer";

	// initialize script
	function OnBeginScript() {
		print("New Quest Notifier initialized");
		local deck, num, note, state;
		for (deck = 1; deck < 10; deck++) {
			for (num = 1; num < 100; num++) {
				note = "note_" + deck + "_" + num;
				state = Quest.Get(note);
				if (Data.GetString("notes", note) != "" && state == 0) {
					Quest.SubscribeMsg(self, note, eQuestDataType.kQuestDataCampaign);
				}
			}
		}
	}

	// handle quest state change
	// Notifications delayed a bit so they won't get buried among the email
	// and cybermod messages that usually accompany quest state changes, and
	// so multiple changes can be batched into a single notification.
	function OnQuestChange() {
		local oldVal = message().m_oldValue;
		local newVal = message().m_newValue;
		if (newVal != oldVal && newVal == 1) {
			if (IsDataSet(notifyTimer)) {
				KillTimer(GetData(notifyTimer))
			}
			SetData(notifyTimer, SetOneShotTimer("QuestNew", 1));
		}
	}

	// display notification	
	function OnTimer() {
		if (message().name == "QuestNew") {
			ClearData(notifyTimer);
			ShockGame.AddText(Data.GetString("misc", "NoteNew", "Note added to PDA."), null);
		}
	}
}
